# Boostlook v3 CSS — Modular Source

## Overview

`boostlook-v3.css` is the next iteration of the Boost Look CSS framework, built from modular source files in `src/css/`. It replaces the monolithic `boostlook.css` with an organized, maintainable file structure while preserving full backward compatibility.

The production `boostlook-v3.css` is generated by concatenating all modules in order via `build-css.sh`.

## File Structure

| File | Description |
|------|-------------|
| `00-header.css` | License, file overview, template structure docs, selector conventions |
| `01-variables.css` | Root CSS custom properties — spacing, typography, icons |
| `02-themes.css` | Light/dark theme variable mappings |
| `03-fonts.css` | `@font-face` declarations (Noto Sans, Monaspace) |
| `04-reset.css` | CSS reset (box-sizing, margins, defaults) |
| `05-global-typography.css` | Base container, headings h1–h6, heading anchors |
| `06-global-links.css` | Paragraph styling, links, footnotes |
| `07-global-code.css` | Code blocks, inline code, syntax highlighting (hljs) |
| `08-global-components.css` | Quotes, pagination, admonitions, lists, edit-page link |
| `09-global-tables-images.css` | Tables, image styles |
| `10-scrollbars.css` | Scrollbar styling (Firefox + WebKit) |
| `11-template-layout.css` | Template-specific scrolling, iframe, TOC common styles |
| `12-asciidoctor.css` | AsciiDoctor-specific styles, Rouge syntax highlighting |
| `13-antora.css` | Antora navigation, toolbar, breadcrumbs, tabs, search |
| `14-quickbook.css` | Quickbook legacy wrapper, titles, TOC, tables, footer |
| `15-readme.css` | Library README styles |
| `16-responsive-toc.css` | AsciiDoctor responsive TOC layout (768px to 1920px) |

## Build Instructions

Run from the repository root:

```sh
sh build-css.sh
```

This concatenates all modules (in numeric order) into `boostlook-v3.css` at the repo root.

## CSS Tooling Roadmap

> **Status:** Decision deferred — documenting options for future reference.

The current build uses a simple shell concatenation script (`build-css.sh`). As the framework matures, we may adopt proper CSS tooling. Options under consideration:

- **Lightning CSS** — Fast bundler/minifier with modern CSS transforms and browser-target downleveling
- **PostCSS** — Plugin-based pipeline (autoprefixer, nesting, custom media queries)
- **stylelint + minification** — Linting for consistency, paired with a dedicated minifier (e.g., cssnano)

Criteria for the eventual decision: build speed, browser compatibility needs, developer ergonomics, and minimal dependency footprint.
