//////////////////////////////////////////////////////////////////////////////
//
// (C) Copyright Ion Gaztanaga 2004-2012. Distributed under the Boost
// Software License, Version 1.0. (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// See http://www.boost.org/libs/interprocess for documentation.
//
//////////////////////////////////////////////////////////////////////////////
#include <map>
#include <boost/interprocess/managed_shared_memory.hpp>
#include <boost/container/map.hpp>
#include <boost/interprocess/allocators/allocator.hpp>
#include <boost/interprocess/indexes/map_index.hpp>
#include <boost/interprocess/indexes/iset_index.hpp>
#include <boost/interprocess/mem_algo/simple_seq_fit.hpp>
#include "print_container.hpp"
#include "movable_int.hpp"
#include "map_test.hpp"
#include "emplace_test.hpp"

///////////////////////////////////////////////////////////////////
//                                                               //
//  This example repeats the same operations with std::map and   //
//  shmem_map using the node allocator                           //
//  and compares the values of both containers                   //
//                                                               //
///////////////////////////////////////////////////////////////////

using namespace boost::interprocess;

//Customize managed_shared_memory class
typedef basic_managed_shared_memory
   <char,
    simple_seq_fit<mutex_family, offset_ptr<void> >,
    map_index
   > my_managed_shared_memory;

//We will work with narrow characters for shared memory objects
//Alias an integer node allocator type
typedef allocator<std::pair<const int, int>, my_managed_shared_memory::segment_manager>
   shmem_node_pair_allocator_t;
typedef allocator<std::pair<const test::movable_int, test::movable_int>, my_managed_shared_memory::segment_manager>
   shmem_movable_node_pair_allocator_t;
typedef allocator<std::pair<const test::movable_and_copyable_int, test::movable_and_copyable_int>, my_managed_shared_memory::segment_manager>
   shmem_move_copy_node_pair_allocator_t;

//Alias standard types
typedef std::map<int, int>                                     MyStdMap;
typedef std::multimap<int, int>                                MyStdMultiMap;

//Alias non-movable types
typedef boost::container::map<int, int, std::less<int>, shmem_node_pair_allocator_t>  MyShmMap;
typedef boost::container::multimap<int, int, std::less<int>, shmem_node_pair_allocator_t>  MyShmMultiMap;

//Alias movable types
typedef boost::container::map<test::movable_int, test::movable_int,
      std::less<test::movable_int>,
      shmem_movable_node_pair_allocator_t>                     MyMovableShmMap;
typedef boost::container::multimap<test::movable_int, test::movable_int,
      std::less<test::movable_int>,
      shmem_movable_node_pair_allocator_t>                     MyMovableShmMultiMap;

typedef boost::container::map<test::movable_and_copyable_int
           ,test::movable_and_copyable_int
           ,std::less<test::movable_and_copyable_int>
           ,shmem_move_copy_node_pair_allocator_t>             MyMoveCopyShmMap;
typedef boost::container::multimap<test::movable_and_copyable_int
                ,test::movable_and_copyable_int
                ,std::less<test::movable_and_copyable_int>
                ,shmem_move_copy_node_pair_allocator_t>        MyMoveCopyShmMultiMap;

int main ()
{
   using namespace boost::interprocess::ipcdetail;

   if (0 != test::map_test<my_managed_shared_memory
                  ,MyShmMap
                  ,MyStdMap
                  ,MyShmMultiMap
                  ,MyStdMultiMap>()){
      return 1;
   }

   if(0 != test::map_test_copyable<my_managed_shared_memory
                        ,MyShmMap
                        ,MyStdMap
                        ,MyShmMultiMap
                        ,MyStdMultiMap>()){
      return 1;
   }

//   if (0 != test::map_test<my_managed_shared_memory
//                  ,MyMovableShmMap
//                  ,MyStdMap
//                  ,MyMovableShmMultiMap
//                  ,MyStdMultiMap>()){
//      return 1;
//   }

   if (0 != test::map_test<my_managed_shared_memory
                  ,MyMoveCopyShmMap
                  ,MyStdMap
                  ,MyMoveCopyShmMultiMap
                  ,MyStdMultiMap>()){
      return 1;
   }

   const test::EmplaceOptions MapOptions = (test::EmplaceOptions)(test::EMPLACE_HINT_PAIR | test::EMPLACE_ASSOC_PAIR);
   if(!boost::interprocess::test::test_emplace<boost::container::map<test::EmplaceInt, test::EmplaceInt>, MapOptions>())
      return 1;
   if(!boost::interprocess::test::test_emplace<boost::container::multimap<test::EmplaceInt, test::EmplaceInt>, MapOptions>())
      return 1;

   return 0;
}
