//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
// Copyright (C) 2011 Vicente J. Botet Escriba
//
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

// <boost/thread/thread.hpp>

// class thread

// template <class Clousure> thread(Clousure f);

#include <new>
#include <cstddef>
#include <cstdlib>
#include <cassert>
#include <boost/thread/thread_only.hpp>
#include <boost/core/lightweight_test.hpp>
#include <boost/config.hpp>

#if ! defined BOOST_NO_CXX11_LAMBDAS

unsigned throw_one = 0xFFFF;

#if defined _GLIBCXX_THROW
void* operator new(std::size_t s) _GLIBCXX_THROW (std::bad_alloc)
#elif defined BOOST_MSVC
void* operator new(std::size_t s)
#elif __cplusplus > 201402L
void* operator new(std::size_t s)
#else
void* operator new(std::size_t s) throw (std::bad_alloc)
#endif
{
  if (throw_one == 0) throw std::bad_alloc();
  --throw_one;
  return std::malloc(s);
}

#if defined BOOST_MSVC
void operator delete(void* p)
#else
void operator delete(void* p) BOOST_NOEXCEPT_OR_NOTHROW
#endif
{
  std::free(p);
}

#if (defined(__cpp_sized_deallocation) && (__cpp_sized_deallocation >= 201309l)) || \
    (BOOST_CXX_VERSION > 201103l && \
        (defined(__GNUC__) && (__GNUC__ >= 5)) || \
        (defined(__clang__) && (__clang_major__ > 3 || (__clang_major__ == 3 && __clang_minor__ >= 4))) || \
        (defined(BOOST_MSVC) && (_MSC_VER >= 1900)) \
    )
#if defined BOOST_MSVC
void operator delete(void* p, std::size_t)
#else
void operator delete(void* p, std::size_t) BOOST_NOEXCEPT_OR_NOTHROW
#endif
{
  operator delete(p);
}
#endif

bool f_run = false;

int main()
{
  {
    f_run = false;
    boost::thread t( []() { f_run = true; } );
    t.join();
    BOOST_TEST(f_run == true);
  }
#if !defined(BOOST_MSVC) && !defined(__MINGW32__)
  {
    f_run = false;
    try
    {
      throw_one = 0;
      boost::thread t( []() { f_run = true; } );
      BOOST_TEST(false);
    }
    catch (...)
    {
      throw_one = 0xFFFF;
      BOOST_TEST(!f_run);
    }
  }
#endif

  return boost::report_errors();
}

#else
int main()
{
  return 0;
}
#endif
