/*
    Copyright (c) 2025 Sam Darwin

    Distributed under the Boost Software License, Version 1.0. (See accompanying
    file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
*/

'use strict'

const sleep = ms => new Promise(res => setTimeout(res, ms));

module.exports.register = function () {
  this.once('contextStarted', () => {
    const { loadUi: loadUiDelegate } = this.getFunctions()
    this.replaceFunctions({
      async loadUi (uiCatalog) {
        let triesCounter = 1;
        let sleepInterval = 5000;
        let numTries = 5;
        while (true) {
            try {
                const result = await loadUiDelegate.call(this, uiCatalog);
                return result;
            } catch(error) {
                if (++triesCounter > numTries) throw error;
            }
            console.log(`Downloading ui-bundle failed, sleeping ${sleepInterval} ms`)
            await sleep(sleepInterval);
        }
      }
    })
  })
}
